<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customers_employees_properties', function(Blueprint $table) {
			$table->foreign('users_customer_id')->references('id')->on('users_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customers_employees_properties', function(Blueprint $table) {
			$table->foreign('users_agent_id')->references('id')->on('users_agents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customers_employees_properties', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('properties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('customers_employees_properties', function(Blueprint $table) {
			$table->dropForeign('customers_employees_properties_users_customer_id_foreign');
		});
		Schema::table('customers_employees_properties', function(Blueprint $table) {
			$table->dropForeign('customers_employees_properties_users_agent_id_foreign');
		});
		Schema::table('customers_employees_properties', function(Blueprint $table) {
			$table->dropForeign('customers_employees_properties_property_id_foreign');
		});
	}
}