<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSetStatesTable extends Migration {

	public function up()
	{
		Schema::create('set_states', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('state')->nullable();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('country_id')->unsigned()->nullable();
			$table->bigInteger('location_id')->unsigned()->nullable();
			$table->bigInteger('create_user_id')->unsigned()->nullable();
			$table->bigInteger('edit_user_id')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('set_states');
	}
}