<?php

namespace UserProfile;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserProfile extends Model 
{

    protected $table = 'user_survey_profiles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user_suburb()
    {
        return $this->hasMany('UserSuburb');
    }

    public function property_user()
    {
        return $this->hasMany('PropertyUser');
    }

    public function more_refine_serch()
    {
        return $this->hasMany('MoreRefineSearch', 'user_profile_id');
    }

    public function userPriceRanges()
    {
        return $this->hasOne('UserPriceRenge');
    }

    public function userPropertyType()
    {
        return $this->hasOne('UserPropertyType');
    }

    public function userBadRoom()
    {
        return $this->hasOne('UserBadRoom');
    }

    public function userMoveIn()
    {
        return $this->hasOne('UserMoveIn');
    }

}