<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSetPriceRangesTable extends Migration {

	public function up()
	{
		Schema::create('set_price_ranges', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->decimal('max_price', 8, 2)->nullable();
			$table->decimal('min_price', 8, 2)->nullable();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('location_id')->unsigned()->nullable();
			$table->bigInteger('create_user_id')->unsigned()->nullable();
			$table->bigInteger('edit_user_id')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('set_price_ranges');
	}
}