<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSetSuburbsTable extends Migration {

	public function up()
	{
		Schema::create('set_suburbs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('suburb')->nullable();
			$table->bigInteger('state_id')->unsigned()->nullable();
			$table->boolean('is_active')->default(1);
			$table->bigInteger('location')->unsigned()->nullable();
			$table->bigInteger('create_user_id')->unsigned()->nullable();
			$table->bigInteger('edit_user_id')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('set_suburbs');
	}
}