<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tolerance extends Eloquent {

	protected $table = 'tolerances';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function services()
	{
		return $this->belongsToMany('Service', 'service_tolerance', 'tolerance_id', 'service_id')->withTimestamps();
	}

}