<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('materials', function(Blueprint $table) {
			$table->foreign('material_type_id')->references('id')->on('material_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_material', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('materials')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_material', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_thickness', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_thickness', function(Blueprint $table) {
			$table->foreign('thickness_id')->references('id')->on('thicknesses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_tolerance', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_tolerance', function(Blueprint $table) {
			$table->foreign('tolerance_id')->references('id')->on('tolerances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_surface_roughness', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('service_surface_roughness')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_surface_roughness', function(Blueprint $table) {
			$table->foreign('surface_roughness_id')->references('id')->on('surface_roughnesses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_accreditation', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_accreditation', function(Blueprint $table) {
			$table->foreign('accreditation_id')->references('id')->on('accreditations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('finish_type_finish', function(Blueprint $table) {
			$table->foreign('finish_id')->references('id')->on('finishes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('finish_type_finish', function(Blueprint $table) {
			$table->foreign('finish_type_id')->references('id')->on('finish_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('material_thickness', function(Blueprint $table) {
			$table->foreign('thickness_id')->references('id')->on('thicknesses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('material_thickness', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('materials')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('technologies', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_finish', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_finish', function(Blueprint $table) {
			$table->foreign('finish_id')->references('id')->on('finishes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('material_finish', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('materials')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('material_finish', function(Blueprint $table) {
			$table->foreign('finish_id')->references('id')->on('finishes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('technology_material', function(Blueprint $table) {
			$table->foreign('technology_id')->references('id')->on('technologies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('technology_material', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('materials')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('primary_finish_secondary_finish', function(Blueprint $table) {
			$table->foreign('primary_finish_id')->references('id')->on('finishes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('primary_finish_secondary_finish', function(Blueprint $table) {
			$table->foreign('secondary_finish_id')->references('id')->on('finishes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('materials', function(Blueprint $table) {
			$table->dropForeign('materials_material_type_id_foreign');
		});
		Schema::table('service_material', function(Blueprint $table) {
			$table->dropForeign('service_material_material_id_foreign');
		});
		Schema::table('service_material', function(Blueprint $table) {
			$table->dropForeign('service_material_service_id_foreign');
		});
		Schema::table('service_thickness', function(Blueprint $table) {
			$table->dropForeign('service_thickness_service_id_foreign');
		});
		Schema::table('service_thickness', function(Blueprint $table) {
			$table->dropForeign('service_thickness_thickness_id_foreign');
		});
		Schema::table('service_tolerance', function(Blueprint $table) {
			$table->dropForeign('service_tolerance_service_id_foreign');
		});
		Schema::table('service_tolerance', function(Blueprint $table) {
			$table->dropForeign('service_tolerance_tolerance_id_foreign');
		});
		Schema::table('service_surface_roughness', function(Blueprint $table) {
			$table->dropForeign('service_surface_roughness_service_id_foreign');
		});
		Schema::table('service_surface_roughness', function(Blueprint $table) {
			$table->dropForeign('service_surface_roughness_surface_roughness_id_foreign');
		});
		Schema::table('service_accreditation', function(Blueprint $table) {
			$table->dropForeign('service_accreditation_service_id_foreign');
		});
		Schema::table('service_accreditation', function(Blueprint $table) {
			$table->dropForeign('service_accreditation_accreditation_id_foreign');
		});
		Schema::table('finish_type_finish', function(Blueprint $table) {
			$table->dropForeign('finish_type_finish_finish_id_foreign');
		});
		Schema::table('finish_type_finish', function(Blueprint $table) {
			$table->dropForeign('finish_type_finish_finish_type_id_foreign');
		});
		Schema::table('material_thickness', function(Blueprint $table) {
			$table->dropForeign('material_thickness_thickness_id_foreign');
		});
		Schema::table('material_thickness', function(Blueprint $table) {
			$table->dropForeign('material_thickness_material_id_foreign');
		});
		Schema::table('technologies', function(Blueprint $table) {
			$table->dropForeign('technologies_service_id_foreign');
		});
		Schema::table('service_finish', function(Blueprint $table) {
			$table->dropForeign('service_finish_service_id_foreign');
		});
		Schema::table('service_finish', function(Blueprint $table) {
			$table->dropForeign('service_finish_finish_id_foreign');
		});
		Schema::table('material_finish', function(Blueprint $table) {
			$table->dropForeign('material_finish_material_id_foreign');
		});
		Schema::table('material_finish', function(Blueprint $table) {
			$table->dropForeign('material_finish_finish_id_foreign');
		});
		Schema::table('technology_material', function(Blueprint $table) {
			$table->dropForeign('technology_material_technology_id_foreign');
		});
		Schema::table('technology_material', function(Blueprint $table) {
			$table->dropForeign('technology_material_material_id_foreign');
		});
		Schema::table('primary_finish_secondary_finish', function(Blueprint $table) {
			$table->dropForeign('primary_finish_secondary_finish_primary_finish_id_foreign');
		});
		Schema::table('primary_finish_secondary_finish', function(Blueprint $table) {
			$table->dropForeign('primary_finish_secondary_finish_secondary_finish_id_foreign');
		});
	}
}