<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SurfaceRoughness extends Eloquent {

	protected $table = 'surface_roughnesses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function services()
	{
		return $this->belongsToMany('Service', 'service_surface_roughness', 'surface_roughness_id', 'service_id')->withTimestamps();
	}

}