<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgrementsTable extends Migration {

	public function up()
	{
		Schema::create('agrements', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('dossier_id')->unsigned();
			$table->integer('centre_id')->unsigned();
			$table->integer('recruteur_id')->unsigned();
			$table->tinyInteger('tem_principal')->default('0');
			$table->smallInteger('nombre_heures');
			$table->tinyInteger('tem_agrement')->nullable()->default('null');
			$table->date('date_agrement');
			$table->string('gestionnaire_agrement', 8)->nullable();
			$table->text('motif')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('agrements');
	}
}