<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupsTable extends Migration {

	public function up()
	{
		Schema::create('groups', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('owner_id')->unsigned();
			$table->string('name');
			$table->bigInteger('category_id')->unsigned();
			$table->string('code');
			$table->text('bio');
			$table->integer('weeklytimegoal');
			$table->enum('type', array('Stopwatch', 'timeblock'));
			$table->bigInteger('goal_id')->unsigned();
			$table->integer('duration')->nullable();
			$table->boolean('is_online')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('groups');
	}
}