<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTestsTable extends Migration {

	public function up()
	{
		Schema::create('tests', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->integer('purchase_id')->unsigned()->index();
			$table->datetime('start_date');
			$table->datetime('last_access');
			$table->json('status');
			$table->boolean('completed');
			$table->float('Holland_R', 5,4);
			$table->float('Holland_I', 5,4);
			$table->float('Holland_A', 5,4);
			$table->float('Holland_S', 5,4);
			$table->float('Holland_E', 5,4);
			$table->float('Holland_C', 5,4);
			$table->float('MBTI_EI', 5,4);
			$table->float('MBTI_SN', 5,4);
			$table->float('MBTI_TF', 5,4);
			$table->float('MBTI_JP', 5,4);
			$table->float('MBTI_R', 5,4);
			$table->float('MBTI_I', 5,4);
			$table->float('MBTI_A', 5,4);
			$table->float('MBTI_S', 5,4);
			$table->float('MBTI_E', 5,4);
			$table->float('MBTI_C', 5,4);
			$table->float('Ability_AR', 5,4);
			$table->float('Ability_CM', 5,4);
			$table->float('Ability_SA', 5,4);
			$table->float('Ability_TP', 5,4);
			$table->float('Ability_VA', 5,4);
			$table->float('Ability_RC', 5,4);
			$table->float('Ability_PR', 5,4);
			$table->float('Ability_SR', 5,4);
			$table->float('Ability_FP', 5,4);
			$table->float('Ability_CP', 5,4);
			$table->timestamps();
			$table->string('version');
		});
	}

	public function down()
	{
		Schema::drop('tests');
	}
}