<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email');
			$table->string('document');
			$table->char('gender');
			$table->date('birthdate');
			$table->integer('country_code')->unsigned()->index();
			$table->integer('department_code')->unsigned();
			$table->integer('municipality_code')->unsigned()->index();
			$table->boolean('photo');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}