<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProgramsTable extends Migration {

	public function up()
	{
		Schema::create('programs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('career_onet_soc_code');
			$table->integer('institution_SNIES_code')->unsigned()->index();
			$table->string('name');
			$table->integer('municipality_code')->unsigned()->index();
			$table->date('resolution_date')->nullable();
			$table->tinyInteger('validity')->nullable();
			$table->string('methodology')->nullable();
			$table->string('duration')->nullable();
			$table->string('url')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('programs');
	}
}