<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationsTable extends Migration {

	public function up()
	{
		Schema::create('donations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('Name', 255);
			$table->smallInteger('Age')->unsigned()->index();
			$table->integer('blood_type_id')->unsigned();
			$table->integer('number_of_blood_cysts')->unsigned();
			$table->string('Hospital_name', 255);
			$table->double('lat');
			$table->integer('Phone_number')->unsigned();
			$table->double('Ing');
			$table->text('Notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('donations');
	}
}