<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('Clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('address', 255);
			$table->integer('city_id');
			$table->string('phone', 100);
			$table->string('email', 255);
			$table->string('commercial_id', 100);
			$table->string('defence_id', 100);
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id');
			$table->integer('area_id');
		});
	}

	public function down()
	{
		Schema::drop('Clients');
	}
}