<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('income', 'payout'));
			$table->integer('sale_id')->unsigned()->nullable();
			$table->integer('payout_id')->unsigned()->nullable();
			$table->string('payment_id')->nullable();
			$table->string('transaction_id')->nullable();
			$table->string('amount')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}