<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tickets extends Eloquent {

	protected $table = 'tickets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('event_id', 'commission_id', 'quantity', 'section', 'row', 'price_actual', 'price_sale', 'url', 'description', 'delivery_option', 'created_by');

	public function getEvent()
	{
		return $this->belongsTo('Events', 'event_id');
	}

	public function getCommission()
	{
		return $this->belongsTo('CommissionMaster', 'commission_id');
	}

	public function getSeller()
	{
		return $this->belongsTo('User', 'created_by');
	}

}