<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Place extends Model 
{

    protected $table = 'places';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function contactInfo()
    {
        return $this->hasOne('ContactInfo', 'id_contact_info');
    }

    public function placeType()
    {
        return $this->hasOne('PlaceType', 'place_type_id');
    }

    public function deals()
    {
        return $this->hasMany('Deal');
    }

}