<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('children', function(Blueprint $table) {
			$table->foreign('account_number')->references('account_number')->on('accounts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branch_user', function(Blueprint $table) {
			$table->foreign('branch_id')->references('row_id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_user', function(Blueprint $table) {
			$table->foreign('age_group_id')->references('id')->on('age_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('age_group_branch', function(Blueprint $table) {
			$table->foreign('branch_id')->references('row_id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('age_group_branch', function(Blueprint $table) {
			$table->foreign('age_group_id')->references('id')->on('age_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('class_rooms', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('class_rooms', function(Blueprint $table) {
			$table->foreign('age_group_id')->references('id')->on('age_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('class_rooms', function(Blueprint $table) {
			$table->foreign('branch_id')->references('row_id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('class_room_attendances', function(Blueprint $table) {
			$table->foreign('child_id')->references('id')->on('children')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('class_room_attendances', function(Blueprint $table) {
			$table->foreign('classroom_id')->references('id')->on('class_rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('visiting_logs', function(Blueprint $table) {
			$table->foreign('account_number')->references('account_number')->on('accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_user_id_foreign');
		});
		Schema::table('children', function(Blueprint $table) {
			$table->dropForeign('children_account_number_foreign');
		});
		Schema::table('branch_user', function(Blueprint $table) {
			$table->dropForeign('branch_user_branch_id_foreign');
		});
		Schema::table('branch_user', function(Blueprint $table) {
			$table->dropForeign('branch_user_age_group_id_foreign');
		});
		Schema::table('branch_user', function(Blueprint $table) {
			$table->dropForeign('branch_user_user_id_foreign');
		});
		Schema::table('age_group_branch', function(Blueprint $table) {
			$table->dropForeign('age_group_branch_branch_id_foreign');
		});
		Schema::table('age_group_branch', function(Blueprint $table) {
			$table->dropForeign('age_group_branch_age_group_id_foreign');
		});
		Schema::table('class_rooms', function(Blueprint $table) {
			$table->dropForeign('class_rooms_teacher_id_foreign');
		});
		Schema::table('class_rooms', function(Blueprint $table) {
			$table->dropForeign('class_rooms_age_group_id_foreign');
		});
		Schema::table('class_rooms', function(Blueprint $table) {
			$table->dropForeign('class_rooms_branch_id_foreign');
		});
		Schema::table('class_room_attendances', function(Blueprint $table) {
			$table->dropForeign('class_room_attendances_child_id_foreign');
		});
		Schema::table('class_room_attendances', function(Blueprint $table) {
			$table->dropForeign('class_room_attendances_classroom_id_foreign');
		});
		Schema::table('visiting_logs', function(Blueprint $table) {
			$table->dropForeign('visiting_logs_account_number_foreign');
		});
	}
}