<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'client';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'phone', 'country');

	public function accounts()
	{
		return $this->belongsToMany('Account', 'client_account', 'client_id', 'account_id');
	}

}