<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = false;

    public function oauths()
    {
        return $this->hasMany('Oauth');
    }

    public function profil()
    {
        return $this->hasOne('Profil');
    }

    public function diplomes()
    {
        return $this->hasMany('Diplome');
    }

    public function cotisation()
    {
        return $this->hasOne('Cotisation');
    }

    public function conjoint()
    {
        return $this->belongsTo('User', 'conjoint_id');
    }

    public function inscriptions()
    {
        return $this->hasMany('Inscription');
    }

}