<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('payment_method_id')->unsigned();
			$table->text('notes')->nullable();
			$table->string('address');
			$table->float('coast');
			$table->float('net');
			$table->float('commission');
			$table->enum('status', array(''pending'', ''accepted'', ''rejected'', ''delivered''));
			$table->integer('restaurant_id')->unsigned();
			$table->integer('client_id')->unsigned();
			$table->double('total');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}