<?php

namespace App\Restaurant;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function restaurants()
	{
		return $this->belongsToMany('App\Restaurant\Restaurant', 'restaurant_id');
	}

}