<?php

namespace App\General;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('payment_method_id', 'notes', 'address', 'coast', 'net', 'commission', 'status', 'restaurant_id', 'client_id', 'total');

	public function products()
	{
		return $this->belongsToMany('App\General\Prouduct', 'product_id');
	}

	public function payment_method()
	{
		return $this->belongsTo('App\Restaurant\PaymentMethod', 'payment_method_id');
	}

	public function transactions()
	{
		return $this->hasMany('App\General\Transaction');
	}

	public function notification()
	{
		return $this->hasOne('App\General\Notification');
	}

	public function restaurant()
	{
		return $this->belongsTo('App\Restaurant\Restaurant', 'restaurant_id');
	}

	public function client()
	{
		return $this->belongsTo('App\Client\Client', 'client_id');
	}

}