<?php

namespace App\General;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Prouduct extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'notes', 'price', 'discount', 'restaurant_id');

	public function restaurant()
	{
		return $this->belongsTo('App\Restaurant\Restaurant', 'restaurant_id');
	}

	public function orders()
	{
		return $this->belongsToMany('App\General\Order', 'order_id');
	}

}