<?php

namespace App\Restaurant;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'phone', 'district_id', 'pin_code', 'api_token', 'password', 'image', 'minimum_charge', 'delivery_charge', 'whats_app_number', 'delivery_time', 'available', 'active');
	protected $hidden = array('api_token', 'password');

	public function districts()
	{
		return $this->belongsTo('App\General\District', 'district_id');
	}

	public function products()
	{
		return $this->hasMany('App\General\Prouduct');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Restaurant\Category', 'category_id');
	}

	public function offers()
	{
		return $this->hasMany('App\Restaurant\Offer');
	}

	public function transactions()
	{
		return $this->hasMany('App\General\Transaction');
	}

	public function reviews()
	{
		return $this->hasMany('App\General\Review');
	}

	public function notifications()
	{
		return $this->morphMany('App\General\Notification', 'notificationable')is_read;
	}

}