<?php

namespace App\General;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Token extends Eloquent {

	protected $table = 'tokens';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('token', 'type', 'client_id');

	public function client()
	{
		return $this->belongsTo('App\Client\Client', 'client_id');
	}

}