<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgentsTable extends Migration {

	public function up()
	{
		Schema::create('agents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('full_name');
			$table->string('email');
			$table->string('phone');
			$table->string('password');
			$table->bigInteger('specialization_id')->unsigned();
			$table->bigInteger('city_id')->unsigned();
			$table->tinyInteger('status');
		});
	}

	public function down()
	{
		Schema::drop('agents');
	}
}