<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBankAccountsTable extends Migration {

	public function up()
	{
		Schema::create('bank_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('bank_name');
			$table->string('bank_holder_name');
			$table->integer('iban');
			$table->integer('account_number');
			$table->integer('swift_code');
			$table->string('bank_branch');
			$table->string('phone');
			$table->bigInteger('agent_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('bank_accounts');
	}
}