<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitsTable extends Migration {

	public function up()
	{
		Schema::create('units', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code');
			$table->string('name');
			$table->string('description');
			$table->boolean('act')->default(1);
			$table->string('subtotal');
			$table->string('tax');
			$table->string('discount');
			$table->string('total');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('units');
	}
}