<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->string('email', 60);
			$table->string('password', 255);
			$table->integer('company_id')->unsigned()->nullable();
			$table->string('phone');
			$table->boolean('holding_admin')->default(0);
			$table->boolean('role_admin')->default(0);
			$table->boolean('role_livestock')->default(0);
			$table->boolean('role_agriculture')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}