<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('holding_id')->references('id')->on('holdings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('holding_id')->references('id')->on('holdings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('farms', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('types', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('salesOrders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('salesInvoices', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('purchaseOrders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('receipts', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipments', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_holding_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_company_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_holding_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_company_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_supplier_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_customer_id_foreign');
		});
		Schema::table('farms', function(Blueprint $table) {
			$table->dropForeign('farms_company_id_foreign');
		});
		Schema::table('items', function(Blueprint $table) {
			$table->dropForeign('items_customer_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_address_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_item_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_contract_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_item_id_foreign');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->dropForeign('departments_item_id_foreign');
		});
		Schema::table('types', function(Blueprint $table) {
			$table->dropForeign('types_item_id_foreign');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->dropForeign('banks_supplier_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_supplier_id_foreign');
		});
		Schema::table('salesOrders', function(Blueprint $table) {
			$table->dropForeign('salesOrders_customer_id_foreign');
		});
		Schema::table('salesInvoices', function(Blueprint $table) {
			$table->dropForeign('salesInvoices_customer_id_foreign');
		});
		Schema::table('purchaseOrders', function(Blueprint $table) {
			$table->dropForeign('purchaseOrders_customer_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_customer_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_supplier_id_foreign');
		});
		Schema::table('receipts', function(Blueprint $table) {
			$table->dropForeign('receipts_supplier_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_address_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_item_id_foreign');
		});
		Schema::table('shipments', function(Blueprint $table) {
			$table->dropForeign('shipments_customer_id_foreign');
		});
	}
}