<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOffersTable extends Migration {

	public function up()
	{
		Schema::create('offers', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('category', 'sub_category', 'product'));
			$table->string('value');
			$table->timestamps();
			$table->tinyInteger('is_active')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('offers');
	}
}