<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('address_id');
			$table->integer('client_id');
			$table->float('total_price');
			$table->float('delivery_cost')->nullable();
			$table->enum('status', array('cart', 'pending', 'accepted', 'rejected', 'delivered'));
			$table->string('phone');
			$table->enum('payment_method', array('when_recieving', 'credit_card'));
			$table->string('code')->nullable();
			$table->text('note')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}