<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->string('path');
			$table->enum('type', array('photo', 'video'));
			$table->enum('grade', array('master', 'normal'));
			$table->string('fileable_type');
			$table->integer('fileable_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}