<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('city_id');
			$table->string('name');
			$table->string('phone');
			$table->string('email');
			$table->enum('gender', array('male', 'female'));
			$table->string('pin_code')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->tinyInteger('is_confirmed')->default('0');
			$table->string('password')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}