<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('level')->nullable();
			$table->string('slug');
			$table->integer('parent_id')->nullable();
			$table->text('description');
			$table->integer('view_home')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}