<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->integer('client_id')->nullable();
			$table->increments('id');
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->text('contact');
			$table->tinyInteger('is_read')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}