<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('slug');
			$table->text('description');
			$table->float('price');
			$table->integer('offer_percent');
			$table->tinyInteger('is_offered')->default('0');
			$table->tinyInteger('is_new')->default('0');
			$table->integer('ordered_number')->default('0');
			$table->integer('level')->nullable();
			$table->integer('rate')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}