<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'email', 'password', 'type', 'image');
	protected $hidden = array('password');

	public function contacts()
	{
		return $this->hasMany('App\Models\Contact');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function carts()
	{
		return $this->hasMany('App\Models\Cart');
	}

	public function messages()
	{
		return $this->hasMany('App\Models\Message');
	}

	public function userAddresses()
	{
		return $this->hasMany('App\Models\UserAddress');
	}

	public function stores()
	{
		return $this->belongsToMany('App\Models\Store');
	}

	public function products()
	{
		return $this->belongsToMany('App\Models\Product');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

}