<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('state_ar', 'state_en', 'sub_cost', 'charge_fees', 'total_price', 'commission', 'net_price', 'client_id', 'store_id', 'coupon_id', 'payment_method_id');

	public function products()
	{
		return $this->belongsToMany('App\Models\Product');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function store()
	{
		return $this->belongsTo('App\Models\Store');
	}

	public function coupon()
	{
		return $this->belongsTo('App\Models\Coupon');
	}

	public function paymentMethod()
	{
		return $this->belongsTo('App\Models\PaymentMethod');
	}

}