<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name_ar');
			$table->string('name_en');
			$table->string('type_ar');
			$table->string('type_en');
			$table->string('description_ar');
			$table->string('description_en');
			$table->string('link');
			$table->boolean('is_approved')->default(0);
			$table->double('lat');
			$table->double('lng');
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}