<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Organization extends Model 
{

    protected $table = 'organizations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function customers()
    {
        return $this->hasMany('Customer', 'organization_id');
    }

    public function organization_details()
    {
        return $this->hasOne('OrganizationDetails', 'organization_id');
    }

}