<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrganizationDetails extends Model 
{

    protected $table = 'organization_details';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function organizations()
    {
        return $this->belongsTo('Organization', 'organization_id');
    }

    public function rebates()
    {
        return $this->belongsTo('Rebate', 'rebate_id');
    }

    public function pricings()
    {
        return $this->belongsTo('Pricing', 'pricing_id');
    }

}