<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEasiSettingsTable extends Migration {

	public function up()
	{
		Schema::create('easiSettings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('state_id');
			$table->double('fuelCost');
			$table->time('handlingTime');
			$table->integer('potentialDelivery');
			$table->integer('mileagePerDay');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('easiSettings');
	}
}