<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Driver extends Eloquent {

	protected $table = 'drivers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function vehicles()
	{
		return $this->belongsTo('Vehicle', 'vehicle_id');
	}

}