<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrganizationDetailsTable extends Migration {

	public function up()
	{
		Schema::create('organization_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('organization_id')->unsigned();
			$table->integer('account_id');
			$table->enum('paymentType', array(''check'', ''card'', ''cash''));
			$table->text('orgLink');
			$table->enum('serviceType', array(''0'', ''1''));
			$table->enum('serviceLevel', array(''bronze'', ''gold'', ''platinum''));
			$table->integer('remainingDelivery');
			$table->integer('pricing_id');
			$table->integer('rebate_id');
			$table->double('freeDeliveryAmount');
			$table->integer('freeDeliveryMiles');
			$table->integer('invoiceDays');
			$table->string('brand', 50);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('organization_details');
	}
}