<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function organizations()
	{
		return $this->belongsTo('Organization', 'organization_id');
	}

	public function customers()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

	public function drivers()
	{
		return $this->belongsTo('Driver', 'driver_id');
	}

	public function oversize()
	{
		return $this->hasMany('OrderItem', 'orderitem_id');
	}

}