<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user_details()
	{
		return $this->hasOne('UserProfile');
	}

	public function user_organizations()
	{
		return $this->hasMany('UserOrganization');
	}

}