<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function organizations()
    {
        return $this->belongsTo('Organization', 'organization_id');
    }

    public function customers()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

    public function drivers()
    {
        return $this->belongsTo('Driver', 'driver_id');
    }

    public function oversize()
    {
        return $this->hasMany('OrderItem', 'orderitem_id');
    }

}